XDim = 30;
YDim = 55;
ZDim = 20;
thickness = 2;
screwRadius = 2.0;

//$fn = 100;

//bubbleEnclosure(XDim, YDim, ZDim, thickness, screwRadius);

module bubbleEnclosure(XDim, YDim, ZDim, thickness, screwRadius){
    xTranslate = XDim/2 + screwRadius*0.707;
    yTranslate = YDim/2 + screwRadius*0.707;
    echo("bubbleEnclosure(XDim, YDim, ZDim, thickness, screwRadius)");
    
    translate([(XDim+(screwRadius+thickness)*5),0,thickness/2]){
        color("Turquoise"){
            lid(XDim, YDim, thickness, screwRadius, xTranslate, yTranslate);
        }
    }
    translate([0,0,(ZDim+thickness)/2]){
        body(XDim, YDim, ZDim, thickness, screwRadius, xTranslate, yTranslate);
    }
}

module body(functionXDimension, functionYDimension, functionZDimension, functionThickness, functionScrewRadius, xDimTranslate, yDimTranslate){
    bubbleRadius = functionThickness*2 + functionScrewRadius;
    wallXDim = functionXDimension + functionThickness*2;
    wallYDim = functionYDimension + functionThickness*2;
    wallZDim = functionZDimension + functionThickness+.001;
    difference(){
        cube([wallXDim, wallYDim, wallZDim], center = true);
        translate([0,0,functionThickness]){
            cube([functionXDimension, functionYDimension, functionZDimension], center = true);
        }
    }
    translate([(xDimTranslate+functionThickness), (yDimTranslate+functionThickness), 0]){
        bodyBubble(wallZDim, bubbleRadius, functionScrewRadius, 180);
    }
    translate([-(xDimTranslate+functionThickness), (yDimTranslate+functionThickness), 0]){
        bodyBubble(wallZDim, bubbleRadius, functionScrewRadius, 270);
    }
    translate([(xDimTranslate+functionThickness), -(yDimTranslate+functionThickness), 0]){
        bodyBubble(wallZDim, bubbleRadius, functionScrewRadius, 90);
    }
    translate([-(xDimTranslate+functionThickness), -(yDimTranslate+functionThickness), 0]){
        bodyBubble(wallZDim, bubbleRadius, functionScrewRadius, 0);
    }
}

module bodyBubble(functionScrewDepth, bubbleRadius, functionScrewRadius){
    receivingScrewHole = functionScrewRadius*0.85;
    difference(){
        cylinder(functionScrewDepth, bubbleRadius, bubbleRadius, center = true);
        cylinder(functionScrewDepth*2, functionScrewRadius, functionScrewRadius, center = true);
//        rotate([0,0,functionRotation]){
//            translate([functionScrewRadius*.707,functionScrewRadius*.707,-functionScrewDepth/2-.001]){
//                cube([bubbleRadius, bubbleRadius, functionScrewDepth+.002]);
//            }
//        }
    }
}

module lid(preXDimension, preYDimension, functionThickness, functionScrewRadius, xDimTranslate, yDimTranslate){
    functionXDimension = preXDimension + 2*functionThickness;
    functionYDimension = preYDimension + 2*functionThickness;
    functionZDimension = preZDimension + 2*functionThickness;
    bubbleRadius = functionThickness*2 + functionScrewRadius;
    cube([functionXDimension, functionYDimension, functionThickness], center = true);
    translate([xDimTranslate+functionThickness, yDimTranslate+functionThickness, 0]){
        lidBubble(functionThickness, bubbleRadius, functionScrewRadius);
    }
    translate([-xDimTranslate-functionThickness, yDimTranslate+functionThickness, 0]){
        lidBubble(functionThickness, bubbleRadius, functionScrewRadius);
    }
    translate([xDimTranslate+functionThickness, -yDimTranslate-functionThickness, 0]){
        lidBubble(functionThickness, bubbleRadius, functionScrewRadius);
    }
    translate([-xDimTranslate-functionThickness, -yDimTranslate-functionThickness, 0]){
        lidBubble(functionThickness, bubbleRadius, functionScrewRadius);
    }
}

module lidBubble(functionThickness, bubbleRadius, functionScrewRadius){
    difference(){
        cylinder(functionThickness, bubbleRadius, bubbleRadius, center = true);
        cylinder(functionThickness*2, functionScrewRadius, functionScrewRadius, center = true);
    }
}